#define inf 0x3fff
#define PLY 16
#define HALF_PLY 8
#define ZUGZWANG_EXTENTION 24
#define LOOK_CLOCK 1023

#define ZUGZWANG_PENALTY 50

unsigned int nNodes;
clock_t stopAlphaBetaTime;
char bSearchStopped;
int nQAlphaBetaDepth;

int QAlphaBeta(int alpha,int beta,int depth)
{
MOVE WinMaterialMoves[MAX_MOVES];
int i,nWinMaterialMoves;
int ev;
if ((++nNodes & LOOK_CLOCK) == 0)
  {
  if (clock() >= stopAlphaBetaTime)
    {
    bSearchStopped = 1;
    return alpha;
    }
  }
ev = nMaterialScore * nSideToMove * BOX_VALUE;
if (!BoxWithEdges[3])
  if ((BoxWithEdges[0] + BoxWithEdges[1]) <= nBorderBoxes)
    {
    return ev - ZUGZWANG_PENALTY;
    }
if (ev >= beta) return ev;
if (alpha < ev) alpha = ev;
if (!depth) return alpha;
depth--;
enumerateCaptures(WinMaterialMoves,&nWinMaterialMoves);
for(i=0;i<nWinMaterialMoves;i++)
  {
  int j,k = i;
  for(j=i+1;j<nWinMaterialMoves;j++)
    if (WinMaterialMoves[k].score < WinMaterialMoves[j].score)
      k = j;
  j = WinMaterialMoves[i].score;
  WinMaterialMoves[i].score = WinMaterialMoves[k].score;
  WinMaterialMoves[k].score = j;
  j = WinMaterialMoves[k].m;
  WinMaterialMoves[k].m = WinMaterialMoves[i].m;
  WinMaterialMoves[i].m = j;
  doMoveWithoutHashCode(j);
  ev = -QAlphaBeta(-beta,-alpha,depth);
  undoMoveWithoutHashCode(j);
  if (bSearchStopped) return alpha;
  if (ev >= beta)
    {
    return beta;
    }
  if (ev > alpha)
    {
    alpha = ev;
    }
  }
return alpha;
}


int AlphaBeta(int alpha,int beta,int depth)
{
MOVE WinMaterialMoves[MAX_MOVES],OtherMoves[MAX_MOVES];
int i,j,k,nWinMaterialMoves,nOtherMoves,ev,nextDepth;
unsigned short hashBestMove,bm;
#ifdef D01
fprintf(stderr,"AlphaBeta(%d,%d,%d)\n",alpha,beta,depth);fflush(stderr);
#endif
if (!BoxWithEdges[3])
  if ((BoxWithEdges[0] + BoxWithEdges[1]) <= nBorderBoxes)
    {
    depth += ZUGZWANG_EXTENTION;
    }
if (depth < 0)
  {
  return QAlphaBeta(alpha,beta,nQAlphaBetaDepth);
  }
if ((++nNodes & LOOK_CLOCK) == 0)
  {
  if (clock() >= stopAlphaBetaTime)
    {
    bSearchStopped = 1;
    return alpha;
    }
  }
ev = hashProbe(alpha,beta,depth,&hashBestMove);
if (ev != HASH_NOT_FOUND) return ev;
nextDepth = depth - PLY;
bm = 0xffff;
if (hashBestMove != 0xffff)
  {
  if (doMoveWithCheck(hashBestMove))
    {
    ev = -AlphaBeta(-beta,-alpha,nextDepth);
    undoMove(hashBestMove);
    if (bSearchStopped) return alpha;
    if (ev >= beta)
      {
      hashStore(ev,depth,hashBestMove,HASH_LOWER_BOUND);
      return beta;
      }
    if (ev > alpha)
      {
      alpha = ev;
      bm = hashBestMove;
      }
    }
  }

enumerateMoves(WinMaterialMoves,&nWinMaterialMoves,OtherMoves,&nOtherMoves);
if ((nWinMaterialMoves + nOtherMoves) == 0)
  return (nMaterialScore * nSideToMove + nLastMoveScore) * BOX_VALUE;

for(i=0;i<nWinMaterialMoves;i++)
  {
  k = i;
  for(j=i+1;j<nWinMaterialMoves;j++)
    if (WinMaterialMoves[k].score < WinMaterialMoves[j].score)
      k = j;
  j = WinMaterialMoves[i].score;
  WinMaterialMoves[i].score = WinMaterialMoves[k].score;
  WinMaterialMoves[k].score = j;
  j = WinMaterialMoves[k].m;
  WinMaterialMoves[k].m = WinMaterialMoves[i].m;
  WinMaterialMoves[i].m = j;
  if (j == hashBestMove) continue;
  doMove(j);
  ev = -AlphaBeta(-beta,-alpha,nextDepth);
  if (bm != 0xffff)
    {
    ev = -AlphaBeta(-alpha-1,-alpha,nextDepth);
    if (alpha < ev && ev < beta) ev = -AlphaBeta(-beta,-alpha,nextDepth);
    }
  else
    {
    ev = -AlphaBeta(-beta,-alpha,nextDepth);
    }
  undoMove(j);
  if (bSearchStopped) return alpha;
  if (ev >= beta)
    {
    hashStore(ev,depth,j,HASH_LOWER_BOUND);
    return beta;
    }
  if (ev > alpha)
    {
    alpha = ev;
    bm = j;
    }
  }

for(i=0;i<nOtherMoves;i++)
  {
  j = OtherMoves[i].m;
  if (j == hashBestMove) continue;
  doMove(j);
  if (bm != 0xffff)
    {
    ev = -AlphaBeta(-alpha-1,-alpha,nextDepth);
    if (alpha < ev && ev < beta) ev = -AlphaBeta(-beta,-alpha,nextDepth);
    }
  else
    {
    ev = -AlphaBeta(-beta,-alpha,nextDepth);
    }
  undoMove(j);
  if (bSearchStopped) return alpha;
  if (ev >= beta)
    {
    hashStore(ev,depth,j,HASH_LOWER_BOUND);
    return beta;
    }
  if (ev > alpha)
    {
    alpha = ev;
    bm = j;
    }
  }
if (bm == 0xffff)
  {
  hashStore(alpha,depth,bm,HASH_UPPER_BOUND);
  }
else
  {
  hashStore(alpha,depth,bm,0);
  }

return alpha;
}

int cmpMove(const void *a,const void *b)
{
return ((MOVE*)b)->score - ((MOVE*)a)->score;
}

#ifdef SHOW_STAT
#define MAX_PV_SIZE 48
void printPV(FILE *f,unsigned short m)
{
unsigned short moves[MAX_PV_SIZE];
int i=0;
#ifdef CHECK_DOMOVE_UNDOMOVE
BOARD b;
storeBoard(&b);
#endif

moves[0] = m;
while(doMoveWithCheck(moves[i]))
  {
  int ev;
  printMove(f,moves[i]);fprintf(f," ");
  i++;
  if (i >= MAX_PV_SIZE) break;
  ev = hashProbe(-inf,inf,0,&moves[i]);
  if (ev == HASH_NOT_FOUND) break;
  if (moves[i] == 0xffff)
    {
    fprintf(f,"*");
    break;
    }
  }
for(i--;i>=0;i--) undoMove(moves[i]);
#ifdef CHECK_DOMOVE_UNDOMOVE
checkBoard(&b);
#endif
}
#endif


unsigned short findMove(double searchTime)
{
double searchTime1,searchTime2;
clock_t st2;
MOVE WinMaterialMoves[MAX_MOVES],OtherMoves[MAX_MOVES];
int i,j,k,depth,nWinMaterialMoves,nOtherMoves,alpha,beta;
unsigned short bm = 0xffff;
int max_depth,upper_bound_player_moves;
#ifdef D00
fprintf(stderr,"thinking_time = [%.3lf,%.3lf]\n",searchTime1,searchTime2);
fflush(stderr);
#endif
simplifyBoardPosition(&max_depth);
/* max_depth = countFreeEdges(); */

upper_bound_player_moves = (max_depth >> 1) + (max_depth & 1);

nMaterialScore = 0;
nSideToMove    = 1;
#ifdef D00
fprintf(stderr,"max_depth = %d\n",max_depth);fflush(stderr);
#endif

if (max_depth <= 17)
  {
  return findMoveEndgame(max_depth);
  }
bSearchStopped = 0;
#ifdef HASH_CODE
initHashTable();
#endif
searchTime -= 3.0;
searchTime2 = searchTime / upper_bound_player_moves;
searchTime1 = searchTime2 * 0.25;
if (2 * searchTime2 < searchTime) searchTime2 *= 1.5;
st2 = (clock_t) (searchTime1 * CLOCKS_PER_SEC);
stopAlphaBetaTime = (clock_t) (searchTime2 * CLOCKS_PER_SEC);
nNodes = 0;
enumerateMoves2(WinMaterialMoves,&nWinMaterialMoves,OtherMoves,&nOtherMoves);
qsort(WinMaterialMoves,nWinMaterialMoves,sizeof(WinMaterialMoves[0]),cmpMove);
for(i=0;i<nOtherMoves;i++) OtherMoves[i].score += rand() & 7;
qsort(OtherMoves,nOtherMoves,sizeof(OtherMoves[0]),cmpMove);

memcpy(&WinMaterialMoves[nWinMaterialMoves],
       &OtherMoves[0],sizeof(OtherMoves[0])*nOtherMoves);

nWinMaterialMoves += nOtherMoves;

if (!nWinMaterialMoves)
  {
  return 0xffff;
  }

bm = WinMaterialMoves[0].m;
if (max_depth < 10)
  {
  nQAlphaBetaDepth = 0;
  }
else if (max_depth < 20)
  {
  nQAlphaBetaDepth = 2;
  }
else
  {
  nQAlphaBetaDepth = 4;
  }

for(depth=0;depth<=max_depth;depth++)
  {
  const int nSearchDepth = (depth * PLY) - (HALF_PLY);
  alpha = -inf-1;beta = inf;
  for(i=0;i<nWinMaterialMoves;i++)
    {
    #ifdef CHECK_DOMOVE_UNDOMOVE
    BOARD b;
    #endif
    int ev;
    #ifdef D01
    fprintf(stderr,"depth=%d ",depth);
    printMove(stderr,WinMaterialMoves[i].m);
    fprintf(stderr,"\n");fflush(stderr);
    #endif

    #ifdef CHECK_DOMOVE_UNDOMOVE
    storeBoard(&b);
    #endif
    doMove(WinMaterialMoves[i].m);
    if (i)
      {
      ev = -AlphaBeta(-alpha-1,-alpha,nSearchDepth);
      if (alpha < ev && ev < beta) ev = -AlphaBeta(-beta,-alpha,nSearchDepth);
      }
    else
      {
      ev = -AlphaBeta(-beta,-alpha,nSearchDepth);
      }
    undoMove(WinMaterialMoves[i].m);
    if (bSearchStopped) goto skip;
    #ifdef CHECK_DOMOVE_UNDOMOVE
    checkBoard(&b);
    #endif
    if (alpha < ev)
      {
      #ifdef SHOW_STAT
      printPV(stderr,WinMaterialMoves[i].m);
      fprintf(stderr,"%d %d %.3Lf %u\n",depth,ev,((long double) clock()) / CLOCKS_PER_SEC,nNodes);
      #endif
      alpha = ev;
      bm = WinMaterialMoves[i].m;
      j = i;
      }
    }
  for(k=j;k>0;k--)
    {
    WinMaterialMoves[k].m = WinMaterialMoves[k-1].m;
    }
  WinMaterialMoves[0].m = bm;
  #ifdef SHOW_STAT
  printPV(stderr,bm);
  fprintf(stderr,"%d %d %.3Lf %u\n",depth,alpha,((long double) clock()) / CLOCKS_PER_SEC,nNodes);
  #endif
  if (clock() >= st2) break;
  }
skip:
#ifdef SHOW_STAT
printPV(stderr,bm);
fprintf(stderr,"%d %d %.3Lf %u\n",depth,alpha,((long double) clock()) / CLOCKS_PER_SEC,nNodes);
#endif
#ifdef HASH_CODE
freeHashTable();
#endif
return bm;
}