/*
  vertex : 1..nRows+1 1..nColumns+1
  Side   :  1 -> first
           -1 -> second
*/
#define HASH_CODE

#ifdef HASH_CODE
typedef unsigned long long u64;
#endif

#define MAX_MOVES 648
typedef struct tagMove
  {
  unsigned short m;
  short score;
  } MOVE;

const int player2int[3] = {0,1,-1};
int nRows,nColumns;
int nRowsp1,nColumnsp1;/*nRows+1,nColumns+1*/
int nBorderBoxes;

int nScore[4];
double nTime[4];

int nComputerSide;
unsigned int horBoard[16];/* y  - */
unsigned int verBoard[16];/* x  | */
unsigned char cellCount[16*16];
char BoxWithEdges[8];



#ifdef HASH_CODE
u64 qHashCode;
#endif



char captures[16][16];
unsigned char BeforeMoveCellCount[16*16];

int nMaterialScore;
int nSideToMove;
int nLastMoveScore=0;


/* ///////////////////// Random numbers for hash codes ///////////////////// */
#ifdef HASH_CODE
u64 tbl_rand[200]={
0x0ULL,0x0ULL,0x0ULL,
0x0ULL,0x0ULL,0x0ULL,
0x0ULL,0x0ULL,0x0ULL,
0x0ULL,0x23f52f401d8b1a04ULL,0xe857e5571dc2e72eULL,
0x63c919e85732bfabULL,0x81b23eb7f2020665ULL,0x1787ad9459d94b8eULL,
0x559c73bdce2c44b7ULL,0xf303e5dcf46d0308ULL,0x602b4684241b5ca9ULL,
0xe04ea02266208c93ULL,0xd0715a3c860f2001ULL,0xece6e0308163b5cfULL,
0x7ebe006d91ce9c9ULL,0xd5a2ac40a6c22a21ULL,0x4b45418489c29a17ULL,
0xb67b7b97c7dea655ULL,0xa6b6a0b0495e89aeULL,0x30756e19fd2d7012ULL,
0xb56cade5e01eb1ddULL,0x85e80cf5ef63e731ULL,0x202f22d6ef205258ULL,
0x3bc1c59d5348f0ffULL,0xecf1e99ae7d6957aULL,0xbb2f18d1f3abc09eULL,
0x1a21a2e50141acefULL,0x2317910f24d1d968ULL,0xb0b9cb6d2313accfULL,
0xc0547455e64af1e7ULL,0x41a1c5aeb671e86aULL,0xa08f5be7171d3e55ULL,
0xf965c64692f3a8ecULL,0xd8b40c9b64cc79a6ULL,0x27df92126c3e081aULL,
0x4b91523df2f5ff01ULL,0xdc213e9dbf0383caULL,0x566f54e69e4492eULL,
0xacd97316222b6582ULL,0xb75ed26cb793214dULL,0x947d24e60a07c618ULL,
0x491e2b552644571eULL,0x98dafa2d64f8b172ULL,0x44eed8da04925870ULL,
0x3a1f0082aa3daa6ULL,0xf9c5b40eff25d74bULL,0x545d15af511768dcULL,
0x63a89bde808aa088ULL,0xbd21877c53374bbaULL,0x9ef12668886f0904ULL,
0x10213e06647107b5ULL,0xbf238a3fab553adULL,0xf97a5596e150e413ULL,
0x866d25f4daabed4ULL,0x98965590482f69c9ULL,0x35a55c7972357540ULL,
0xb95fc54f4e5868cfULL,0x2fc42482bfd4e560ULL,0xfb6a6fad64f48770ULL,
0x34b41503fb5541c9ULL,0xafcd1924956fd984ULL,0xa6393427f1d50854ULL,
0xad92a2f3f05bbe40ULL,0x2ad85201075b22b9ULL,0xc1d63d5055b6b4e6ULL,
0x2f0d41525ea415acULL,0x5e8dbd7b993278ceULL,0x51f48b83aeee6fc5ULL,
0xa51da4f48a93c317ULL,0xba4f50a1c83f4535ULL,0x8a2eeca4f7450f8bULL,
0xf94fa5a1edc45b25ULL,0x1a6b2c310fdf15f6ULL,0x16c71ace02fd3a6eULL,
0x5991a081845e614aULL,0x5860f1648d576eadULL,0xde0afd5d682cb7d1ULL,
0xc9419ade62a9ce84ULL,0xbb72261632f79d8aULL,0xb428262f3a5ccdefULL,
0xb27c1944eddfae4dULL,0xa5ef690b3b54517aULL,0xb0bb1790a31b074fULL,
0x580ea892859ab2faULL,0x3d13370014f3e42fULL,0xdc873a933e5dded1ULL,
0xafa89c3ff07e4efaULL,0x2f0cf37ba5a364bfULL,0x46d0b7e9c0a34810ULL,
0xf6d0f505413c6bc9ULL,0x9f9e0ad84645a32eULL,0xf1e98d902fd309bULL,
0x9d2493c38ca57a39ULL,0x0ULL,0x7d0174f9687ebdf3ULL,
0xccf6a1a4e098dbd9ULL,0x99bb945dfda58497ULL,0x3f6e5cfc2f8d2f45ULL,
0x5cca56744b6fb290ULL,0xa1e80638ec7172eULL,0x200d5a10ad6ed952ULL,
0xd3a019b33c294b16ULL,0xe61396ce9068e935ULL,0x0ULL,
0x737ac2b5dfee45edULL,0x306f3729d725ddf8ULL,0xbd34c6668b0d24c4ULL,
0x47247a1db284f649ULL,0x2a17f6c4a39f79daULL,0xc3db41b2c35aeaf2ULL,
0xdb26c27a1a0d1537ULL,0x38989770ae9af9aaULL,0xb0f86b4b6358571eULL,
0x0ULL,0xda4eace8d8e438a4ULL,0x95cd7c985adfbf87ULL,
0xd29b37c50754696fULL,0x46c75203651408fdULL,0x6fe277d2313cb2f8ULL,
0xd3a55812394c51b2ULL,0x60d7ee21642ec06cULL,0xa7609945f628558eULL,
0x29a1646f8d8924d6ULL,0x0ULL,0xf8a2fce67e85ab97ULL,
0x359a4bf5ec4f37a1ULL,0x92181c7a4d70dc81ULL,0xc9a3a1df61c61db2ULL,
0x9f7a721b82913bcaULL,0xafde131b5233f97eULL,0x18d2dbe5ffdb422bULL,
0xf7c08c737aebb519ULL,0x66aced1d9c6a80c2ULL,0x0ULL,
0xe348ebcb4715b821ULL,0x8a8090e24a4e9d2dULL,0x868b54a4e53efb0ULL,
0x9d644aebef03ad1dULL,0x2a0795b72f47b1f8ULL,0xb6ccc42006c27f0aULL,
0xd2374a8b0ad8e5caULL,0x9fd4287e490a6052ULL,0x601a8e13e05f5766ULL,
0x0ULL,0x97c770d4142c9d89ULL,0x596b1d13042d38e8ULL,
0xf676e81f7e1384feULL,0x2bc4ebd718c60ef7ULL,0x8b50ff627d0cce85ULL,
0x9d1d8e08c168ae1aULL,0x8127f764fc00df9cULL,0x47c1652b24ea1843ULL,
0xd02ad309bee5b51bULL,0x0ULL,0xd0602ef400409113ULL,
0x8cd5868c57402919ULL,0x45870d9235bc934ULL,0x245410821b77cd5bULL,
0xbda537127ca0461aULL,0x3ad787ddc148623aULL,0xe8ad2d47c918c90cULL,
0xc9205c8549be95f5ULL,0xa3b147ab4e4a77f2ULL,0x0ULL,
0x3b0bf982a08610fdULL,0x7fe550bb036aef61ULL,0xf7dfc45acf4462e3ULL,
0x6d118e35ed190032ULL,0xe7aba1373b91cb7dULL,0x2bc11f41423c058bULL,
0xb436bf1096e8a29bULL,0x513099039a9a4a22ULL,0xaa667720f60f2d3cULL,
0x0ULL,0x3b4a8248b1e69e74ULL,0x82d038d595bcbec1ULL,
0x6d213096e39db86fULL,0x93b675a82642c602ULL,0xc71d52d2d1b3365ULL,
0x6dae60e384a73bfaULL,0x947cc8f1ca44d761ULL,0xc4489fab80b9e18aULL,
0x152f4b203c2155beULL,0x0ULL,0x117518566fb68280ULL,
0x63977a3d1f987862ULL,0xf8d077aced879c49ULL,0x60ce50b228e6947ULL,
0x63baef3db967dce7ULL,0xaa898e60d9267ca2ULL,0x365ee3f3e9997a4cULL,
0xebeda4d74a6c5205ULL,0xb866e6d64fa33715ULL};
#endif
/* ///////////////////////////////////////////////////////////////////////// */
typedef struct
   {
#ifdef HASH_CODE
   u64 qHashCode;
#endif
   unsigned int horBoard[16];
   unsigned int verBoard[16];
   unsigned char cellCount[16*16];
   int nMaterialScore;
   int nSideToMove;
   char BoxWithEdges[8];
   } BOARD;

void storeBoard(BOARD *b)
{
memcpy(b->horBoard,horBoard,sizeof(horBoard));
memcpy(b->verBoard,verBoard,sizeof(verBoard));
memcpy(b->cellCount,cellCount,sizeof(cellCount));
memcpy(b->BoxWithEdges,BoxWithEdges,sizeof(BoxWithEdges));
b->nMaterialScore = nMaterialScore;
b->nSideToMove = nSideToMove;
#ifdef HASH_CODE
b->qHashCode = qHashCode;
#endif
}
void restoreBoard(BOARD *b)
{
memcpy(horBoard,b->horBoard,sizeof(horBoard));
memcpy(verBoard,b->verBoard,sizeof(verBoard));
memcpy(cellCount,b->cellCount,sizeof(cellCount));
memcpy(BoxWithEdges,b->BoxWithEdges,sizeof(BoxWithEdges));
nMaterialScore = b->nMaterialScore;
nSideToMove = b->nSideToMove;
#ifdef HASH_CODE
qHashCode = b->qHashCode;
#endif
}



#ifdef CHECK_DOMOVE_UNDOMOVE
void checkBoard(BOARD *b)
{
assert(!memcmp(b->horBoard,horBoard,sizeof(horBoard)));
assert(!memcmp(b->verBoard,verBoard,sizeof(verBoard)));
assert(!memcmp(b->cellCount,cellCount,sizeof(cellCount)));
assert(b->nMaterialScore == nMaterialScore);
assert(b->nSideToMove == nSideToMove);
assert(!memcmp(b->BoxWithEdges,BoxWithEdges,sizeof(BoxWithEdges)));
#ifdef HASH_CODE
assert(b->qHashCode == qHashCode);
#endif
}
#endif


/* ////////////////////// Move generation list ///////////////////// */
int nXMoves[512];
unsigned char nXMoveArray[36*512];
int nYMoves[512];
unsigned char nYMoveArray[36*512];

/* ///////////////////////////////////////////////////////////////// */

#define YFROM(x) ((x) >> 12)
#define XFROM(x) (((x) >> 8) & 15)
#define YTO(x)   (((x) >> 4) & 15)
#define XTO(x)   ((x) & 15)
#define MAKE_MOVE(y1,x1,y2,x2) (((((((y1)<<4)|(x1))<<4)|(y2))<<4)|(x2))

unsigned short cellStr2short(const char *s)
{
return ((s[1] - '1' + 1) << 4) | (s[0] - 'A' + 1);
}

void updateMoveList(int k,int max_size,
                    int nMoves[512],unsigned char nMoveArray[36*512])
{
int i,j;
assert(k < 512);
#ifdef D10
fprintf(stderr,"k=%d max_size=%d\n",k,max_size);
#endif
nMoves[k] = 0;
for(i=1;i<max_size;i++)
  for(j=i+1;j<=max_size;j++)
    {
    const int mask = ((1 << j) - 1) ^ ((1 << i) - 1);
    if (mask & k) continue;
    #ifdef D10
    fprintf(stderr,"%d %d max_size=%d\n",i,j,max_size);
    #endif
    assert(nMoves[k]<36);
    nMoveArray[(nMoves[k]<<9)|k] = (i << 4) | j;
    nMoves[k]++;
    }
}

void initBoard(int nr,int nc,int compPlayer)
{
int i;
#ifdef D00
fprintf(stderr,"initBoard(nr=%d,nc=%d,compPlayer=%d)\n",nr,nc,compPlayer);
#endif
nRows = nr;
nColumns = nc;
nRowsp1=nr+1;
nColumnsp1 = nc+1;
nBorderBoxes = 2 * (nr + nc);

nComputerSide = compPlayer;
memset(horBoard,0,sizeof(horBoard));
memset(verBoard,0,sizeof(verBoard));
memset(cellCount,0,sizeof(cellCount));
memset(captures,0,sizeof(captures));
memset(BoxWithEdges,0,sizeof(BoxWithEdges));
BoxWithEdges[0] = nr * nc + nBorderBoxes;

#ifdef HASH_CODE
qHashCode = 0;
#endif

updateMoveList(0,nr+1,nYMoves,nYMoveArray);
for(i=1;i<1 << nr;i++) updateMoveList(2*i,nr+1,nYMoves,nYMoveArray);

updateMoveList(0,nc+1,nXMoves,nXMoveArray);
for(i=1;i<1 << nc;i++) updateMoveList(2*i,nc+1,nXMoves,nXMoveArray);
}

int countFreeEdges(void)
{
int i,j,res = 0;
for(j=1;j<=nRowsp1;j++)
  {
  const int k = horBoard[j];
  for(i=1;i<=nColumns;i++)
    if (!(k & (1 << i))) res++;
  }
for(i=1;i<=nColumnsp1;i++)
  {
  const int k = verBoard[i];
    for(j=1;j<=nRows;j++)
      if (!(k & (1 << j))) res++;
  }
return res;
}
int upperBoundPlayerMoves(void)
{
int k = countFreeEdges();
return (k >> 1) + (k & 1);
}



int countScore(int player)
{
int i,j,res=0;
for(j=1;j<=nRows;j++)
  for(i=1;i<=nColumns;i++)
    if (captures[j][i] == player) res++;
return res;
}

void beforeDoMove(void)
{
memcpy(BeforeMoveCellCount,cellCount,sizeof(cellCount));
}

void updateCaptures(int player)
{
int i,j;
for(j=1;j<=nRows;j++)
  for(i=1;i<=nColumns;i++)
    if (cellCount[(j<<4)|i] == 4 && BeforeMoveCellCount[(j<<4)|i] < 4)
      captures[j][i] = player;
}
void printMove(FILE *f,unsigned short m)
{
const int x1 = XFROM(m),y1 = YFROM(m),x2 = XTO(m),y2 = YTO(m);
fputc(x1 + 'A' - 1,f);
fputc(y1 + '1' - 1,f);
fputc(' ',f);
fputc(x2 + 'A' - 1,f);
fputc(y2 + '1' - 1,f);
}

#ifdef D00
void printMoveList(FILE *f,MOVE *m,int n)
{
int i;
for(i=0;i<n;i++)
  {
  printMove(f,m[i].m);
  fprintf(f," %d\n",(int) m[i].score);
  }
}

void printBoard(FILE *f,unsigned short m)
{
int i,j;
for(i=0;i<80;i++) fputc('=',f);fputc('\n',f);
for(j=1;j<=nRows;j++)
  {
  for(i=1;i<=nColumns;i++)
    {
    fputc('+',f);
    if (horBoard[j] & (1 << i)) fputc('-',f);else fputc(' ',f);
    }
  fputc('+',f);
  fputc('\n',f);
  for(i=1;i<=nColumns;i++)
    {
    if (verBoard[i] & (1 << j)) fputc('|',f);else fputc(' ',f);
    if (captures[j][i] == 1) fputc('X',f);
    else if (captures[j][i] == -1) fputc('O',f);
    else if (cellCount[(j<<4)|i]==4) fputc('N',f);
    else fputc(' ',f);
    }
  if (verBoard[nColumns+1] & (1 << j)) fputc('|',f);
  fputc('\n',f);
  }
for(i=1;i<=nColumns;i++)
  {
  fputc('+',f);
  if (horBoard[nRows+1] & (1 << i)) fputc('-',f);else fputc(' ',f);
  }
fputc('+',f);
fputc('\n',f);
fputc('\n',f);
fprintf(f,"Last move : ");printMove(f,m);fputc('\n',f);
fprintf(f,"%d : %d\n",countScore(1),countScore(-1));
for(i=0;i<80;i++) fputc('=',f);fputc('\n',f);
fflush(f);
}
#endif

int doMoveWithCheck(unsigned short m)
{
const int x1 = XFROM(m),y1 = YFROM(m),x2 = XTO(m),y2 = YTO(m),
          before = BoxWithEdges[4];
assert(x1 >= 1 && x1 <= nColumnsp1);
assert(y1 >= 1 && y1 <= nRowsp1);
#ifdef D10
printBoard(stderr,m);
#endif
if (x1 == x2)
  {
  int y;
  const int mask = ((1 << y2)) - ((1 << y1));
  if (verBoard[x1] & mask) return 0;
  verBoard[x1] ^= mask;
  #ifdef HASH_CODE
  qHashCode ^= tbl_rand[y2 * 10 + x1] ^ tbl_rand[y1 * 10 + x1];
  #endif
  y = y1;
  do
    {
    register int k = cellCount[(y<<4)|x1]++;
    BoxWithEdges[k]--;
    BoxWithEdges[k+1]++;
    k = cellCount[(y<<4)|(x1-1)]++;
    BoxWithEdges[k]--;
    BoxWithEdges[k+1]++;
    y++;
    } while(y<y2);
  }
else
  {
  int x;
  const int mask = ((1 << x2)) - ((1 << x1));
  if (horBoard[y1] & mask) return 0;
  horBoard[y1] ^= mask;
  #ifdef HASH_CODE
  qHashCode ^= tbl_rand[100 + y1 * 10 + x1] ^ tbl_rand[100 + y1 * 10 + x2];
  #endif
  x = x1;
  do
    {
    register int k = cellCount[(y1<<4)|x]++;
    BoxWithEdges[k]--;
    BoxWithEdges[k+1]++;
    k = cellCount[((y1-1)<<4)|x]++;
    BoxWithEdges[k]--;
    BoxWithEdges[k+1]++;
    x++;
    } while(x<x2);
  }
nMaterialScore += (BoxWithEdges[4] - before) * nSideToMove;
nSideToMove *= -1;
return 1;
}

void doMove(unsigned short m)
{
const int x1 = XFROM(m),y1 = YFROM(m),x2 = XTO(m),y2 = YTO(m),
          before = BoxWithEdges[4];
assert(x1 >= 1 && x1 <= nColumnsp1);
assert(y1 >= 1 && y1 <= nRowsp1);
#ifdef D10
printBoard(stderr,m);
#endif
if (x1 == x2)
  {
  int y;
  #ifdef D00
  assert((verBoard[x1] & ((((1 << y2) - 1) ^ ((1 << y1) - 1)))) == 0);
  #endif
  verBoard[x1] ^= ((1 << y2)) - ((1 << y1));

  #ifdef HASH_CODE
  qHashCode ^= tbl_rand[y2 * 10 + x1] ^ tbl_rand[y1 * 10 + x1];
  #endif
  y = y1;
  do
    {
    register int k = cellCount[(y<<4)|x1]++;
    BoxWithEdges[k]--;
    BoxWithEdges[k+1]++;
    k = cellCount[(y<<4)|(x1-1)]++;
    BoxWithEdges[k]--;
    BoxWithEdges[k+1]++;
    y++;
    } while(y<y2);
  }
else
  {
  int x;
  #ifdef D00
  assert(x1 <= x2);
  assert(y1 == y2);
  assert((horBoard[y1] & (((1 << x2) - 1) ^ ((1 << x1) - 1))) == 0);
  #endif
  horBoard[y1] ^= ((1 << x2)) - ((1 << x1));

  #ifdef HASH_CODE
  qHashCode ^= tbl_rand[100 + y1 * 10 + x1] ^ tbl_rand[100 + y1 * 10 + x2];
  #endif
  x = x1;
  do
    {
    register int k = cellCount[(y1<<4)|x]++;
    BoxWithEdges[k]--;
    BoxWithEdges[k+1]++;
    k = cellCount[((y1-1)<<4)|x]++;
    BoxWithEdges[k]--;
    BoxWithEdges[k+1]++;
    x++;
    } while(x<x2);
  }
nMaterialScore += (BoxWithEdges[4] - before) * nSideToMove;
nSideToMove *= -1;
}

void undoMove(unsigned short m)
{
const int x1 = XFROM(m),y1 = YFROM(m),x2 = XTO(m),y2 = YTO(m),
          before = BoxWithEdges[4];
if (x1 == x2)
  {
  int y;
  verBoard[x1] ^= ((1 << y2)) - ((1 << y1));
  #ifdef HASH_CODE
  qHashCode ^= tbl_rand[y2 * 10 + x1] ^ tbl_rand[y1 * 10 + x1];
  #endif
  y = y1;
  do
    {
    register int k = cellCount[(y<<4)|x1]--;
    BoxWithEdges[k]--;
    BoxWithEdges[k-1]++;
    k = cellCount[(y<<4)|(x1-1)]--;
    BoxWithEdges[k]--;
    BoxWithEdges[k-1]++;
    y++;
    } while(y<y2);
  }
else
  {
  int x;
  horBoard[y1] ^= ((1 << x2)) - ((1 << x1));
  #ifdef HASH_CODE
  qHashCode ^= tbl_rand[100 + y1 * 10 + x1] ^ tbl_rand[100 + y1 * 10 + x2];
  #endif
  x = x1;
  do
    {
    register int k = cellCount[(y1<<4)|x]--;
    BoxWithEdges[k]--;
    BoxWithEdges[k-1]++;
    k = cellCount[((y1-1)<<4)|x]--;
    BoxWithEdges[k]--;
    BoxWithEdges[k-1]++;
    x++;
    } while(x<x2);
  }
nMaterialScore -= (BoxWithEdges[4] - before) * nSideToMove;
nSideToMove *= -1;
}

void doMoveWithoutHashCode(unsigned short m)
{
const int x1 = XFROM(m),y1 = YFROM(m),x2 = XTO(m),y2 = YTO(m),
          before = BoxWithEdges[4];
assert(x1 >= 1 && x1 <= nColumnsp1);
assert(y1 >= 1 && y1 <= nRowsp1);
#ifdef D10
printBoard(stderr,m);
#endif
if (x1 == x2)
  {
  int y;
  #ifdef D00
  assert((verBoard[x1] & ((((1 << y2) - 1) ^ ((1 << y1) - 1)))) == 0);
  #endif
  verBoard[x1] ^= ((1 << y2)) - ((1 << y1));
  y = y1;
  do
    {
    register int k = cellCount[(y<<4)|x1]++;
    BoxWithEdges[k]--;
    BoxWithEdges[k+1]++;
    k = cellCount[(y<<4)|(x1-1)]++;
    BoxWithEdges[k]--;
    BoxWithEdges[k+1]++;
    y++;
    } while(y<y2);
  }
else
  {
  int x;
  #ifdef D00
  assert(x1 <= x2);
  assert(y1 == y2);
  assert((horBoard[y1] & (((1 << x2) - 1) ^ ((1 << x1) - 1))) == 0);
  #endif
  horBoard[y1] ^= ((1 << x2)) - ((1 << x1));
  x = x1;
  do
    {
    register int k = cellCount[(y1<<4)|x]++;
    BoxWithEdges[k]--;
    BoxWithEdges[k+1]++;
    k = cellCount[((y1-1)<<4)|x]++;
    BoxWithEdges[k]--;
    BoxWithEdges[k+1]++;
    x++;
    } while(x<x2);
  }
nMaterialScore += (BoxWithEdges[4] - before) * nSideToMove;
nSideToMove *= -1;
}

void undoMoveWithoutHashCode(unsigned short m)
{
const int x1 = XFROM(m),y1 = YFROM(m),x2 = XTO(m),y2 = YTO(m),
          before = BoxWithEdges[4];
if (x1 == x2)
  {
  int y;
  verBoard[x1] ^= ((1 << y2)) - ((1 << y1));
  y = y1;
  do
    {
    register int k = cellCount[(y<<4)|x1]--;
    BoxWithEdges[k]--;
    BoxWithEdges[k-1]++;
    k = cellCount[(y<<4)|(x1-1)]--;
    BoxWithEdges[k]--;
    BoxWithEdges[k-1]++;
    y++;
    } while(y<y2);
  }
else
  {
  int x;
  horBoard[y1] ^= ((1 << x2)) - ((1 << x1));
  x = x1;
  do
    {
    register int k = cellCount[(y1<<4)|x]--;
    BoxWithEdges[k]--;
    BoxWithEdges[k-1]++;
    k = cellCount[((y1-1)<<4)|x]--;
    BoxWithEdges[k]--;
    BoxWithEdges[k-1]++;
    x++;
    } while(x<x2);
  }
nMaterialScore -= (BoxWithEdges[4] - before) * nSideToMove;
nSideToMove *= -1;
}
void setPlayerInfo(int player,int score,double tm)
{
nScore[player] = score;
nTime[player] = tm;
}


unsigned short moveStr2short(const char *s1,const char *s2)
{
return (cellStr2short(s1) << 8) | cellStr2short(s2);
}
void DoMoveWithScore(int player,const char *s1,const char *s2)
{
unsigned short m = moveStr2short(s1,s2);
player = player2int[player];
nSideToMove = player;
beforeDoMove();
doMove(m);
updateCaptures(player);
#ifdef D00
printBoard(stderr,m);
#endif
}
const short tbl_enum_moves_score[8] = {0,0,-8,256,0,0,0,0};
void enumerateMoves2(MOVE *WinMaterialMoves,int *nWinMaterialMoves,
                     MOVE *OtherMoves,int *nOtherMoves)
{
short h[10];
int i,j,o;
*nWinMaterialMoves = *nOtherMoves = 0;
for(j=1;j<=nRowsp1;j++)
  {
  const int k = horBoard[j];
  unsigned char *p = nXMoveArray + k;
  memset(h,0,sizeof(h[0])*nColumnsp1);
  for(i=1;i<=nColumns;i++)
    {
    h[i] += tbl_enum_moves_score[cellCount[(j<<4)|i]];
    h[i] += tbl_enum_moves_score[cellCount[((j-1)<<4)|i]];
    }
  for(i=1;i<=nColumns;i++) h[i] += h[i-1];
  for(o=nXMoves[k];o>0;o--)
    {
    const int x1 = (*p) >> 4,
              x2 = (*p) & 15,
              score  = h[x2-1] - h[x1-1];
    if (score > 0)
      {
      WinMaterialMoves[*nWinMaterialMoves].m = MAKE_MOVE(j,x1,j,x2);
      WinMaterialMoves[*nWinMaterialMoves].score = score;
      (*nWinMaterialMoves)++;
      }
    else
      {
      OtherMoves[*nOtherMoves].m = MAKE_MOVE(j,x1,j,x2);
      OtherMoves[*nOtherMoves].score = score;
      (*nOtherMoves)++;
      }
    p += 512;
    }
  }
for(i=1;i<=nColumnsp1;i++)
  {
  const int k = verBoard[i];
  unsigned char *p = nYMoveArray + k;
  memset(h,0,sizeof(h[0])*nRowsp1);
  for(j=1;j<=nRows;j++)
    {
    h[j] += tbl_enum_moves_score[cellCount[(j<<4)|i]];
    h[j] += tbl_enum_moves_score[cellCount[(j<<4)|(i-1)]];
    }
  for(j=1;j<=nRows;j++) h[j] += h[j-1];
  for(o=nYMoves[k];o>0;o--)
    {
    const int y1 = (*p) >> 4,
              y2 = (*p) & 15,
              score  = h[y2-1] - h[y1-1];
    if (score > 0)
      {
      WinMaterialMoves[*nWinMaterialMoves].m = MAKE_MOVE(y1,i,y2,i);
      WinMaterialMoves[*nWinMaterialMoves].score = score;
      (*nWinMaterialMoves)++;
      }
    else
      {
      OtherMoves[*nOtherMoves].m = MAKE_MOVE(y1,i,y2,i);
      OtherMoves[*nOtherMoves].score = score;
      (*nOtherMoves)++;
      }
    p += 512;
    }
  }
#ifdef D10
for(i=0;i<*nWinMaterialMoves;i++)
  {
  const unsigned short m = WinMaterialMoves[i].m;
  const int x1 = XFROM(m),y1 = YFROM(m),x2 = XTO(m),y2 = YTO(m);
  assert(x1 >= 1 && x1 <= nColumnsp1);
  assert(y1 >= 1 && y1 <= nRowsp1);
  }
for(i=0;i<*nOtherMoves;i++)
  {
  const unsigned short m = OtherMoves[i].m;
  const int x1 = XFROM(m),y1 = YFROM(m),x2 = XTO(m),y2 = YTO(m);
  assert(x1 >= 1 && x1 <= nColumnsp1);
  assert(y1 >= 1 && y1 <= nRowsp1);
  }
#endif
}


void enumerateMoves(MOVE *WinMaterialMoves,int *nWinMaterialMoves,
                    MOVE *OtherMoves,int *nOtherMoves)
{
char h[10];
int i,j,o;
*nWinMaterialMoves = *nOtherMoves = 0;
for(j=1;j<=nRowsp1;j++)
  {
  const int k = horBoard[j];
  unsigned char *p = nXMoveArray + k;
  memset(h,0,sizeof(h));
  for(i=1;i<=nColumns;i++)
    {
    if (cellCount[(j<<4)|i] == 3) h[i]++;
    if (cellCount[((j-1)<<4)|i] == 3) h[i]++;
    }
  for(i=1;i<=nColumns;i++) h[i] += h[i-1];
  for(o=nXMoves[k];o>0;o--)
    {
    const int x1 = (*p) >> 4,
              x2 = (*p) & 15,
              score  = h[x2-1] - h[x1-1];
    if (score > 0)
      {
      WinMaterialMoves[*nWinMaterialMoves].m = MAKE_MOVE(j,x1,j,x2);
      WinMaterialMoves[*nWinMaterialMoves].score = score;
      (*nWinMaterialMoves)++;
      }
    else
      {
      OtherMoves[*nOtherMoves].m = MAKE_MOVE(j,x1,j,x2);
      #ifdef D00
      OtherMoves[*nOtherMoves].score = score;
      #endif
      (*nOtherMoves)++;
      }
    p += 512;
    }
  }
for(i=1;i<=nColumnsp1;i++)
  {
  const int k = verBoard[i];
  unsigned char *p = nYMoveArray + k;
  memset(h,0,sizeof(h));
  for(j=1;j<=nRows;j++)
    {
    if (cellCount[(j<<4)|i] == 3) h[j]++;
    if (cellCount[(j<<4)|(i-1)] == 3) h[j]++;
    }
  for(j=1;j<=nRows;j++) h[j] += h[j-1];
  for(o=nYMoves[k];o>0;o--)
    {
    const int y1 = (*p) >> 4,
              y2 = (*p) & 15,
              score  = h[y2-1] - h[y1-1];
    if (score > 0)
      {
      WinMaterialMoves[*nWinMaterialMoves].m = MAKE_MOVE(y1,i,y2,i);
      WinMaterialMoves[*nWinMaterialMoves].score = score;
      (*nWinMaterialMoves)++;
      }
    else
      {
      OtherMoves[*nOtherMoves].m = MAKE_MOVE(y1,i,y2,i);
      #ifdef D00
      OtherMoves[*nOtherMoves].score = score;
      #endif
      (*nOtherMoves)++;
      }
    p += 512;
    }
  }
#ifdef D10
for(i=0;i<*nWinMaterialMoves;i++)
  {
  const unsigned short m = WinMaterialMoves[i].m;
  const int x1 = XFROM(m),y1 = YFROM(m),x2 = XTO(m),y2 = YTO(m);
  assert(x1 >= 1 && x1 <= nColumnsp1);
  assert(y1 >= 1 && y1 <= nRowsp1);
  }
for(i=0;i<*nOtherMoves;i++)
  {
  const unsigned short m = OtherMoves[i].m;
  const int x1 = XFROM(m),y1 = YFROM(m),x2 = XTO(m),y2 = YTO(m);
  assert(x1 >= 1 && x1 <= nColumnsp1);
  assert(y1 >= 1 && y1 <= nRowsp1);
  }
#endif
}

void enumerateCaptures(MOVE *WinMaterialMoves,int *nWinMaterialMoves)
{
char h[10];
int i,j,o;
*nWinMaterialMoves = 0;
for(j=1;j<=nRowsp1;j++)
  {
  const int k = horBoard[j];
  unsigned char *p = nXMoveArray + k;
  memset(h,0,sizeof(h));
  for(i=1;i<=nColumns;i++)
    {
    if (cellCount[(j<<4)|i] == 3) h[i]++;
    if (cellCount[((j-1)<<4)|i] == 3) h[i]++;
    }
  for(i=1;i<=nColumns;i++) h[i] += h[i-1];
  for(o=nXMoves[k];o>0;o--)
    {
    const int x1 = (*p) >> 4,
              x2 = (*p) & 15,
              score  = h[x2-1] - h[x1-1];
    if (score > 0)
      {
      WinMaterialMoves[*nWinMaterialMoves].m = MAKE_MOVE(j,x1,j,x2);
      WinMaterialMoves[*nWinMaterialMoves].score = score;
      (*nWinMaterialMoves)++;
      }
    p += 512;
    }
  }
for(i=1;i<=nColumnsp1;i++)
  {
  const int k = verBoard[i];
  unsigned char *p = nYMoveArray + k;
  memset(h,0,sizeof(h));
  for(j=1;j<=nRows;j++)
    {
    if (cellCount[(j<<4)|i] == 3) h[j]++;
    if (cellCount[(j<<4)|(i-1)] == 3) h[j]++;
    }
  for(j=1;j<=nRows;j++) h[j] += h[j-1];
  for(o=nYMoves[k];o>0;o--)
    {
    const int y1 = (*p) >> 4,
              y2 = (*p) & 15,
              score  = h[y2-1] - h[y1-1];
    if (score > 0)
      {
      WinMaterialMoves[*nWinMaterialMoves].m = MAKE_MOVE(y1,i,y2,i);
      WinMaterialMoves[*nWinMaterialMoves].score = score;
      (*nWinMaterialMoves)++;
      }
    p += 512;
    }
  }
}

void enumerateAllMoves(MOVE *Moves,int *nMoves)
{
MOVE OtherMoves[MAX_MOVES];
int i,nOtherMoves;
enumerateMoves(Moves,nMoves,OtherMoves,&nOtherMoves);
for(i=0;i<nOtherMoves;i++)
  {
  Moves[*nMoves].m = OtherMoves[i].m;
  Moves[*nMoves].score = 0;
  (*nMoves)++;
  }
}

int checkBlockedMove(unsigned short m)
{
const int x1 = XFROM(m),y1 = YFROM(m),x2 = XTO(m),y2 = YTO(m);
if (x1 == x2)
  {
  int k = verBoard[x1];
  const int mask = ((1 << y2)) - ((1 << y1));
  if (k & mask) return 0;
  if (y1 > 1) if (!(k & (1 << (y1 - 1)))) return 0;
  if (y2 <= nRows) if (!(k & (1 << y2))) return 0;
  }
else
  {
  int k = horBoard[y1];
  const int mask = ((1 << x2)) - ((1 << x1));
  if (k & mask) return 0;
  if (x1 > 1) if (!(k & (1 << (x1 - 1)))) return 0;
  if (x2 <= nColumns) if (!(k & (1 << x2))) return 0;
  }
return 1;
}

void simplifyBoardPosition(int *p_nEdges)
{
int i,j;
BOARD b;
nLastMoveScore = 0;
storeBoard(&b);
for(j=1;j<=nRows-1;j++)
  for(i=1;i<=nColumns-1;i++)
    {
    int l = (j << 4) | i;
    if (cellCount[l] == 2 && cellCount[l+1] == 2 &&
        cellCount[l+16] == 2 && cellCount[l+17] == 2)
      {
      unsigned short m1 = MAKE_MOVE(j+1,i,j+1,i+2),
                     m2 = MAKE_MOVE(j,i+1,j+2,i+1);
      if (checkBlockedMove(m1) && checkBlockedMove(m2))
        {
        nLastMoveScore -= 2;
        doMove(m1);
        doMove(m2);
        #ifdef D00
        fprintf(stderr,"Square detected\n");
        printMove(stderr,m1);fprintf(stderr,"\n");
        printMove(stderr,m2);fprintf(stderr,"\n");
        printBoard(stderr,0xffff);
        #endif
        }
      }
    }
for(j=1;j<=nRows;j++)
  for(i=1;i<=nColumns-2;i++)
    {
    int l = (j << 4) | i;
    if (cellCount[l] == 3 && cellCount[l+1] == 2 && cellCount[l+2] == 3)
      {
      unsigned short m1 = MAKE_MOVE(j,i+1,j+1,i+1),
                     m2 = MAKE_MOVE(j,i+2,j+1,i+2);
      if (checkBlockedMove(m1) && checkBlockedMove(m2))
        {
        nLastMoveScore--;
        doMove(m1);
        doMove(m2);
        #ifdef D00
        fprintf(stderr,"3 in one line detected\n");
        printMove(stderr,m1);fprintf(stderr,"\n");
        printMove(stderr,m2);fprintf(stderr,"\n");
        printBoard(stderr,0xffff);
        #endif
        }
      }
    }

for(j=1;j<=nRows-2;j++)
  for(i=1;i<=nColumns;i++)
    {
    int l = (j << 4) | i;
    if (cellCount[l] == 3 && cellCount[l+16] == 2 && cellCount[l+32] == 3)
      {
      unsigned short m1 = MAKE_MOVE(j+1,i,j+1,i+1),
                     m2 = MAKE_MOVE(j+2,i,j+2,i+1);
      if (checkBlockedMove(m1) && checkBlockedMove(m2))
        {
        nLastMoveScore--;
        doMove(m1);
        doMove(m2);
        #ifdef D00
        fprintf(stderr,"3 in one column detected\n");
        printMove(stderr,m1);fprintf(stderr,"\n");
        printMove(stderr,m2);fprintf(stderr,"\n");
        printBoard(stderr,0xffff);
        #endif
        }
      }
    }

for(j=1;j<=nRows-1;j++)
  for(i=1;i<=nColumns-1;i++)
    {
    int l = (j << 4) | i;
    if (cellCount[l] == 2 && cellCount[l+1] == 3 && cellCount[l+16] == 3)
      {
      unsigned short m1 = MAKE_MOVE(j+1,i,j+1,i+1),
                     m2 = MAKE_MOVE(j,i+1,j+1,i+1);
      if (checkBlockedMove(m1) && checkBlockedMove(m2))
        {
        nLastMoveScore--;
        doMove(m1);
        doMove(m2);
        #ifdef D00
        fprintf(stderr,"ugolok detected\n");
        printMove(stderr,m1);fprintf(stderr,"\n");
        printMove(stderr,m2);fprintf(stderr,"\n");
        printBoard(stderr,0xffff);
        #endif
        }
      }
    }


for(j=1;j<=nRows-1;j++)
  for(i=1;i<=nColumns-1;i++)
    {
    int l = (j << 4) | i;
    if (cellCount[l] == 3 && cellCount[l+1] == 2 && cellCount[l+17] == 3)
      {
      unsigned short m1 = MAKE_MOVE(j+1,i+1,j+1,i+2),
                     m2 = MAKE_MOVE(j,i+1,j+1,i+1);
      if (checkBlockedMove(m1) && checkBlockedMove(m2))
        {
        nLastMoveScore--;
        doMove(m1);
        doMove(m2);
        #ifdef D00
        fprintf(stderr,"ugolok2 detected\n");
        printMove(stderr,m1);fprintf(stderr,"\n");
        printMove(stderr,m2);fprintf(stderr,"\n");
        printBoard(stderr,0xffff);
        #endif
        }
      }
    }
if (cellCount[(1<<4)|1] == 2)
  {
  unsigned short m1 = MAKE_MOVE(1,1,2,1),
                 m2 = MAKE_MOVE(1,1,1,2);
  if (checkBlockedMove(m1) && checkBlockedMove(m2))
    {
    nLastMoveScore--;
    doMove(m1);
    doMove(m2);
    #ifdef D00
    fprintf(stderr,"corner1 detected\n");
    printMove(stderr,m1);fprintf(stderr,"\n");
    printMove(stderr,m2);fprintf(stderr,"\n");
    printBoard(stderr,0xffff);
    #endif
    }
  }
if (cellCount[(1<<4)|nColumns] == 2)
  {
  unsigned short m1 = MAKE_MOVE(1,nColumns+1,2,nColumns+1),
                 m2 = MAKE_MOVE(1,nColumns,1,nColumns+1);
  if (checkBlockedMove(m1) && checkBlockedMove(m2))
    {
    nLastMoveScore--;
    doMove(m1);
    doMove(m2);
    #ifdef D00
    fprintf(stderr,"corner2 detected\n");
    printMove(stderr,m1);fprintf(stderr,"\n");
    printMove(stderr,m2);fprintf(stderr,"\n");
    printBoard(stderr,0xffff);
    #endif
    }
  }
if (cellCount[(nRows<<4)|1] == 2)
  {
  unsigned short m1 = MAKE_MOVE(nRows,1,nRows+1,1),
                 m2 = MAKE_MOVE(nRows+1,1,nRows+1,2);
  if (checkBlockedMove(m1) && checkBlockedMove(m2))
    {
    nLastMoveScore--;
    doMove(m1);
    doMove(m2);
    #ifdef D00
    fprintf(stderr,"corner3 detected\n");
    printMove(stderr,m1);fprintf(stderr,"\n");
    printMove(stderr,m2);fprintf(stderr,"\n");
    printBoard(stderr,0xffff);
    #endif
    }
  }
if (cellCount[(nRows<<4)|nColumns] == 2)
  {
  unsigned short m1 = MAKE_MOVE(nRows,nColumns+1,nRows+1,nColumns+1),
                 m2 = MAKE_MOVE(nRows+1,nColumns,nRows+1,nColumns+1);
  if (checkBlockedMove(m1) && checkBlockedMove(m2))
    {
    nLastMoveScore--;
    doMove(m1);
    doMove(m2);
    #ifdef D00
    fprintf(stderr,"corner4 detected\n");
    printMove(stderr,m1);fprintf(stderr,"\n");
    printMove(stderr,m2);fprintf(stderr,"\n");
    printBoard(stderr,0xffff);
    #endif
    }
  }

*p_nEdges = countFreeEdges();
if (*p_nEdges == 0)
  {
  restoreBoard(&b);
  *p_nEdges = countFreeEdges();
  }
}



#ifdef D00
void printPossibleMoves(FILE *f)
{
MOVE WinMaterialMoves[MAX_MOVES],OtherMoves[MAX_MOVES];
int nWinMaterialMoves,nOtherMoves;
enumerateMoves(WinMaterialMoves,&nWinMaterialMoves,
               OtherMoves,&nOtherMoves);
fprintf(f,"Winning material moves:\n");
printMoveList(f,WinMaterialMoves,nWinMaterialMoves);
fprintf(f,"Other moves:\n");
printMoveList(f,OtherMoves,nOtherMoves);
}
#endif


