#ifdef HASH_CODE
#define HASH_SIZE 0x40000
#define HASH_AND  0x3ffff


#define HASH_NOT_FOUND 0x7fff
#define HASH_UPPER_BOUND 0x8000
#define HASH_LOWER_BOUND 0x4000
#define HASH_DEPTH_BITS  0x3fff

/*
memory per entry = 8 + 2 + 2 + 2 = 14 (28 bytes)
*/
u64   *hash_h,*hash_h2;
short *hash_eval,*hash_eval2;
unsigned short *hash_flags,*hash_flags2;
unsigned short *hash_best_move,*hash_best_move2;

void initHashTable(void)
{
hash_h = (u64*) malloc(sizeof(hash_h[0]) * HASH_SIZE);
hash_eval = (short*) malloc(sizeof(hash_eval[0]) * HASH_SIZE);
hash_flags = (unsigned short*) malloc(sizeof(hash_flags[0]) * HASH_SIZE);
hash_best_move = (unsigned short*) malloc(sizeof(hash_best_move[0]) * HASH_SIZE);
hash_h2 = (u64*) malloc(sizeof(hash_h2[0]) * HASH_SIZE);
hash_eval2 = (short*) malloc(sizeof(hash_eval2[0]) * HASH_SIZE);
hash_flags2 = (unsigned short*) malloc(sizeof(hash_flags2[0]) * HASH_SIZE);
hash_best_move2 = (unsigned short*) malloc(sizeof(hash_best_move2[0]) * HASH_SIZE);
memset(hash_h,0,sizeof(hash_h[0]) * HASH_SIZE);
memset(hash_h2,0,sizeof(hash_h2[0]) * HASH_SIZE);
hash_h[0] = hash_h2[0] = 1;
}
void freeHashTable(void)
{
free(hash_h);free(hash_eval);free(hash_flags);free(hash_best_move);
free(hash_h2);free(hash_eval2);free(hash_flags2);free(hash_best_move2);
}
short hashProbe(int alpha,int beta,int depth,unsigned short *bm)
{
unsigned int k = qHashCode & HASH_AND;
*bm = 0xffff;
if (hash_h[k] == qHashCode)
  {
  const int d = hash_flags[k] & HASH_DEPTH_BITS,
           ev = hash_eval[k] + nMaterialScore * nSideToMove * BOX_VALUE;
  *bm = hash_best_move[k];
  if (d >= depth)
    {
    if (hash_flags[k] & HASH_UPPER_BOUND) /* eval <= hash_eval[k] */
      {
      if (ev <= alpha) return alpha;
      }
    else if (hash_flags[k] & HASH_LOWER_BOUND) /* eval >= hash_eval[k] */
      {
      if (ev >= beta) return beta;
      }
    else
      {
      return ev;
      }
    }
  }
if (hash_h2[k] == qHashCode)
  {
  const int d = hash_flags2[k] & HASH_DEPTH_BITS,
           ev = hash_eval2[k] + nMaterialScore * nSideToMove;
  *bm = hash_best_move2[k];
  if (d >= depth)
    {
    if (hash_flags2[k] & HASH_UPPER_BOUND)
      {
      if (ev <= alpha) return alpha;
      }
    else if (hash_flags2[k] & HASH_LOWER_BOUND)
      {
      if (ev >= beta) return beta;
      }
    else
      {
      return ev;
      }
    }
  }


return HASH_NOT_FOUND;
}
void hashStore(int ev,int depth,unsigned short bm,unsigned short flags)
{
unsigned int k = qHashCode & HASH_AND;
ev -= nMaterialScore * nSideToMove * BOX_VALUE;
if ((hash_flags[k] & HASH_DEPTH_BITS) < depth)
  {
  hash_h[k] = qHashCode;
  hash_best_move[k] = bm;
  hash_flags[k] = depth | flags;
  hash_eval[k] = ev;
  }
else
  {
  hash_h2[k] = qHashCode;
  hash_best_move2[k] = bm;
  hash_flags2[k] = depth | flags;
  hash_eval2[k] = ev;
  }
}

#endif