unsigned int tbl_endgame_hc[200];
unsigned int uHashCode,maxHashCode;
char *endgame_eval;

void initEngameHashCodes(void)
{
int i,j,x,y;
unsigned int l=1;
memset(tbl_endgame_hc,0,sizeof(tbl_endgame_hc));
for(i=1;i<=nColumnsp1;i++)
  {
  const int k = verBoard[i];
  for(j=1;j<=nRows;j++)
    if (!(k & (1 << j)))
      {
      tbl_endgame_hc[(j+1) * 10 + i] = l;
      l <<= 1;
      }
  }
for(j=1;j<=nRowsp1;j++)
  {
  const int k = horBoard[j];
  for(i=1;i<=nColumns;i++)
    if (!(k & (1 << i)))
      {
      tbl_endgame_hc[101 + j * 10 + i] = l;
      l <<= 1;
      }
  }
for(x=0;x<10;x++)
  {
  tbl_endgame_hc[0 * 10 + x] = 0;
  for(y=1;y<10;y++)
    tbl_endgame_hc[y * 10 + x] ^= tbl_endgame_hc[(y-1) * 10 + x];
  }
for(y=0;y<10;y++)
  {
  tbl_endgame_hc[100 + 10 * y + 0] = 0;
  for(x=1;x<10;x++)
    tbl_endgame_hc[100 + y * 10 + x] ^= tbl_endgame_hc[100 + y * 10 + x - 1];
  }
uHashCode = 0;
assert(l == maxHashCode);
}

void doMoveEndgame(unsigned short m)
{
const int x1 = XFROM(m),y1 = YFROM(m),x2 = XTO(m),y2 = YTO(m);
assert(x1 >= 1 && x1 <= nColumnsp1);
assert(y1 >= 1 && y1 <= nRowsp1);
#ifdef D10
printBoard(stderr,m);
#endif
nMaterialScore = 0;
if (x1 == x2)
  {
  int y;
  assert(tbl_endgame_hc[y2 * 10 + x1] ^ tbl_endgame_hc[y1 * 10 + x1]);
  assert(!(uHashCode & (tbl_endgame_hc[y2 * 10 + x1] ^ tbl_endgame_hc[y1 * 10 + x1])));
  uHashCode ^= tbl_endgame_hc[y2 * 10 + x1] ^ tbl_endgame_hc[y1 * 10 + x1];
  verBoard[x1] ^= ((1 << y2)) - ((1 << y1));
  for(y=y1;y<y2;y++)
    {
    if (++cellCount[(y<<4)|x1  ] == 4) nMaterialScore++;
    if (++cellCount[(y<<4)|(x1-1)] == 4) nMaterialScore++;
    }
  }
else
  {
  int x;
  uHashCode ^= tbl_endgame_hc[100 + y1 * 10 + x1] ^ tbl_endgame_hc[100 + y1 * 10 + x2];
  horBoard[y1] ^= ((1 << x2)) - ((1 << x1));
  for(x=x1;x<x2;x++)
    {
    if (++cellCount[(y1<<4)|x] == 4) nMaterialScore++;
    if (++cellCount[((y1-1)<<4)|x] == 4) nMaterialScore++;
    }
  }
}

void undoMoveEndgame(unsigned short m)
{
const int x1 = XFROM(m),y1 = YFROM(m),x2 = XTO(m),y2 = YTO(m);
if (x1 == x2)
  {
  int y;
  verBoard[x1] ^= ((1 << y2)) - ((1 << y1));
  uHashCode ^= tbl_endgame_hc[y2 * 10 + x1] ^ tbl_endgame_hc[y1 * 10 + x1];
  for(y=y1;y<y2;y++)
    {
    --cellCount[(y<<4)|x1  ];
    --cellCount[(y<<4)|(x1-1)];
    }
  }
else
  {
  int x;
  horBoard[y1] ^= ((1 << x2)) - ((1 << x1));
  uHashCode ^= tbl_endgame_hc[100 + y1 * 10 + x1] ^ tbl_endgame_hc[100 + y1 * 10 + x2];
  for(x=x1;x<x2;x++)
    {
    --cellCount[(y1<<4)|x];
    --cellCount[((y1-1)<<4)|x];
    }
  }
}

void enumerateMovesEndgame(unsigned short *moves,int *nMoves)
{
int i,j,o;
*nMoves = 0;
for(j=1;j<=nRowsp1;j++)
  {
  const int k = horBoard[j];
  unsigned char *p = nXMoveArray + k;
  for(o=nXMoves[k];o>0;o--)
    {
    const int x1 = (*p) >> 4,
              x2 = (*p) & 15;
    moves[(*nMoves)++] = MAKE_MOVE(j,x1,j,x2);
    p += 512;
    }
  }
for(i=1;i<=nColumnsp1;i++)
  {
  const int k = verBoard[i];
  unsigned char *p = nYMoveArray + k;
  for(o=nYMoves[k];o>0;o--)
    {
    const int y1 = (*p) >> 4,
              y2 = (*p) & 15;
    moves[(*nMoves)++] = MAKE_MOVE(y1,i,y2,i);
    p += 512;
    }
  }
}

int EndgameNegaMax()
{
unsigned short moves[MAX_MOVES];
int i,nMoves,ev,alpha;
#ifdef CHECK_DOMOVE_UNDOMOVE
unsigned int before = uHashCode;
#endif
if (endgame_eval[uHashCode] != 0x7f)
  {
  return endgame_eval[uHashCode];
  }
alpha = -100;
enumerateMovesEndgame(moves,&nMoves);
assert(nMoves>0);
for(i=0;i<nMoves;i++)
  {
  doMoveEndgame(moves[i]);
  #ifdef CHECK_DOMOVE_UNDOMOVE
  assert(uHashCode > before);
  #endif
  ev = nMaterialScore;
  ev -= EndgameNegaMax();
  if (alpha < ev) alpha = ev;
  undoMoveEndgame(moves[i]);
  #ifdef CHECK_DOMOVE_UNDOMOVE
  assert(uHashCode == before);
  #endif
  }
assert(alpha > -100);
return endgame_eval[uHashCode] = alpha;
}
unsigned short findMoveEndgame(int nEdges)
{
int nTBLSize = sizeof(endgame_eval[0])<<nEdges;
unsigned short moves[MAX_MOVES],bm=0xffff;
int i,nMoves,ev,alpha;
#ifdef D00
fprintf(stderr,"nEdges = %d\n",nEdges);
#endif
maxHashCode = 1 << nEdges;
initEngameHashCodes();
endgame_eval = (char*) malloc(nTBLSize);
memset(endgame_eval,0x7f,nTBLSize);
endgame_eval[maxHashCode-1] = nLastMoveScore;
alpha = -100;
enumerateMovesEndgame(moves,&nMoves);
assert(nMoves > 0);
for(i=0;i<nMoves;i++)
  {
  #ifdef SHOW_STAT
  unsigned int hc;
  #endif
  doMoveEndgame(moves[i]);
  #ifdef SHOW_STAT
  hc = uHashCode;
  #endif
  ev = nMaterialScore;
  ev -= EndgameNegaMax();
  if (alpha < ev) {alpha = ev;bm = moves[i];}
  undoMoveEndgame(moves[i]);
  #ifdef SHOW_STAT
  printMove(stderr,moves[i]);
  fprintf(stderr," %d %d\n",ev,hc);
  #endif
  }
free(endgame_eval);
return bm;
}
