/*@@ Wedit generated application. Written Fri Mar 10 19:23:30 2006
 @@header: d:\programs\acm\potm\linesbox\gui\linesboxres.h
 @@resources: d:\programs\acm\potm\linesbox\gui\linesbox.rc
 Do not edit outside the indicated areas */
/*<---------------------------------------------------------------------->*/
/*<---------------------------------------------------------------------->*/
#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include "d:\programs\acm\potm\linesbox\gui\linesboxres.h"
/*<---------------------------------------------------------------------->*/
#include "rules.c"

HANDLE hStdOut;
HINSTANCE hInst;    // Instance handle
HWND hwndMain;    //Main window handle

LRESULT CALLBACK MainWndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

/*<---------------------------------------------------------------------->*/
/*@@0->@@*/
const int cell = 40;

static BOOL InitApplication(void)
{
  WNDCLASS wc;

  memset(&wc,0,sizeof(WNDCLASS));
  wc.style = CS_GLOBALCLASS |CS_HREDRAW|CS_VREDRAW |CS_DBLCLKS ;
  wc.lpfnWndProc = (WNDPROC)MainWndProc;
  wc.hInstance = hInst;
  wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
  wc.lpszClassName = "linesboxWndClass";
  wc.lpszMenuName = MAKEINTRESOURCE(IDMAINMENU);
  wc.hCursor = LoadCursor(NULL,IDC_ARROW);
  wc.hIcon = LoadIcon(NULL,IDI_APPLICATION);
  if (!RegisterClass(&wc))
    return 0;
/*@@0<-@@*/
  // ---TODO--- Call module specific initialization routines here

  return 1;
}

/*<---------------------------------------------------------------------->*/
/*@@1->@@*/
HWND CreatelinesboxWndClassWnd(void)
{
  return CreateWindowEx(WS_EX_TOPMOST,
    "linesboxWndClass","linesbox",
    WS_VISIBLE|WS_CLIPSIBLINGS|WS_CLIPCHILDREN|WS_CAPTION|WS_BORDER
    |WS_SYSMENU
    ,
    0,0,11*cell,11*cell,
    NULL,
    NULL,
    hInst,
    NULL);
}
/*@@1<-@@*/
/*<---------------------------------------------------------------------->*/
/* --- The following code comes from d:\util\c\lib\wizard\defOnCmd.tpl. */
void MainWndProc_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
  switch(id) {
    // ---TODO--- Add new menu commands here
    /*@@NEWCOMMANDS@@*/
    case IDM_EXIT:
    PostMessage(hwnd,WM_CLOSE,0,0);
    break;
  }
}

/*<---------------------------------------------------------------------->*/
/*@@2->@@*/
LRESULT CALLBACK MainWndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
  switch (msg) {
/*@@3->@@*/
  case WM_COMMAND:
    HANDLE_WM_COMMAND(hwnd,wParam,lParam,MainWndProc_OnCommand);
    break;
  case WM_DESTROY:
    PostQuitMessage(0);
    break;
  default:
    return DefWindowProc(hwnd,msg,wParam,lParam);
  }
/*@@3<-@@*/
  return 0;
}
/*@@2<-@@*/

char szPath[MAX_PATH];

char szFirstPlayer[MAX_PATH];
char szSecondPlayer[MAX_PATH];
unsigned short moves[1024];
int nMoves;
int nr,nc,curPlayer;

const char szTL[] = "Time limit (%s)\n";
char szGameTxt[MAX_PATH];

int bStopGame;

void LogLastError(void)
{
    LPVOID lpMsgBuf;
    FormatMessage(
        FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
        NULL,
        GetLastError(),
        MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
        (LPTSTR) &lpMsgBuf,
        0,
        NULL
    );
    // Display the string.
    MessageBox(0,lpMsgBuf,0,MB_OK);
    //fprintf(stderr,"%s\n",lpMsgBuf);
    //EeyoreChessProgram_WriteToLog((char*)lpMsgBuf,LOG_ERR);
    // Free the buffer.
    LocalFree( lpMsgBuf );
}

HANDLE pipe_in,pipe_out;
unsigned char pipe_buf[1024];

HPEN redPen,bluePen;
HBRUSH redBrush,blueBrush;

unsigned char cellCount[16][16];
char captures[16][16];
unsigned char BeforeMoveCellCount[16][16];

void drawMove(HWND hwnd,unsigned short m)
{
int i,j;
PAINTSTRUCT ps;
HGDIOBJ h1,h2;
const int x1 = XFROM(m),y1 = YFROM(m),x2 = XTO(m),y2 = YTO(m);
//BeginPaint(hwnd,&ps);
ps.hdc = GetDC(hwnd);
h1=SelectObject(ps.hdc,(curPlayer == 1) ? redPen : bluePen);
h2=SelectObject(ps.hdc,(curPlayer == 1) ? redBrush : blueBrush);
MoveToEx(ps.hdc,cell * x1,cell * y1,NULL);
LineTo(ps.hdc,cell * x2,cell * y2);
for(j=1;j<=nRows;j++) for(i=1;i<=nColumns;i++)
  if (cellCount[j][i] == 4 && cellCount[j][i] != BeforeMoveCellCount[j][i])
    {
    Rectangle(ps.hdc,cell*i+1,cell*j+1,cell*i+cell,cell*j+cell);
    }
SelectObject(ps.hdc,h1);
SelectObject(ps.hdc,h2);
ReleaseDC(hwnd,ps.hdc);
//EndPaint(hwnd,&ps);
}

char szMoveFile[] = "__move.txt";

int doMoveFromPipe(HANDLE *h)
{
char s1[256],s2[256];
MOVE m[MAX_MOVES];
int i,n;
unsigned short mm;
HANDLE hf;
//FILE *f;
//f = fopen(szFile,"r");
//if (f == 0) return 0;
pipe_buf[0] = 0;


#ifndef USE_PIPE
hf = CreateFile(szMoveFile,GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
ReadFile(hf,pipe_buf,1024,&n,NULL);
CloseHandle(hf);
#endif

#ifdef USE_PIPE
ReadFile(pipe_in,pipe_buf,1024,&n,NULL);
#endif


if (!n) return 0;

if (sscanf(pipe_buf,"%s%s",s1,s2) != 2) return 0;
//fclose(f);
enumerateAllMoves(m,&n);
mm = moveStr2short(s1,s2);
for(i=0;i<n;i++)
  {
  if (mm == m[i].m)
    {
    //printf("%s %s",s1,s2);
    moves[nMoves++] = mm;
    DoMoveWithScore(curPlayer,s1,s2);
    drawMove(hwndMain,mm);
    return 1;
    }
  }
return 0;
}

void printGame(FILE *f)
{
int i;
fprintf(f,"%d %d %d\n",curPlayer,nr,nc);
for(i=1;i<=2;i++)
  {
  fprintf(f,"%d %d %.2Lf\n",i,countScore(player2int[i]),nTime[i]);
  }
for(i=0;i<nMoves;i++)
  {
  fprintf(f,"%d ",(i&1)+1);
  printMove(f,moves[i]);
  fprintf(f,"\n");
  }

}

void printInputFile(void)
{
FILE *f;
f = fopen(szGameTxt,"w");
printGame(f);
fclose(f);
}

long double ft2ld(const FILETIME *ft)
{
long double x;
x = ft->dwHighDateTime;
x *= 4294967296.0;
x += ft->dwLowDateTime;
x *= 1e-7;
return x;
}

double fMatchPoints[2];

void GetMove(const char *szExeName)
{
STARTUPINFO si;
PROCESS_INFORMATION pi;
char szCommand[MAX_PATH];

#ifndef USE_PIPE
HANDLE hMoveFile;
#endif

//HANDLE h;
//HANDLE herr;
//FILE *f;
//DWORD st;
printInputFile();
//h = CreateFile("lastmove",GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
//herr = CreateFile("last.err",GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);


//f = fopen("lastmove","w");
memset(&si,0,sizeof(si));
si.cb = sizeof(si);
//si.dwFlags = STARTF_USESTDHANDLES | STARTF_USESHOWWINDOW;
//si.hStdOutput = pipe_out;
si.dwFlags =  STARTF_USESHOWWINDOW;
si.wShowWindow  = SW_HIDE;
//si.hStdError = herr;

/*
f = fopen("__tmp.bat","w");
fprintf(f,"%s %s >lastmove\n",szExeName,szGameTxt);
fclose(f);
*/
#ifndef USE_PIPE
hMoveFile = CreateFile(szMoveFile,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
SetStdHandle(STD_OUTPUT_HANDLE,hMoveFile);
#endif

sprintf(szCommand,"%s %s",szExeName,szGameTxt);
//if (!CreateProcess("__tmp.bat",NULL,0,0,TRUE,CREATE_NEW_CONSOLE,NULL,NULL,&si,&pi))
//if (!CreateProcess(szExeName,szGameTxt,0,0,TRUE,0,NULL,NULL,&si,&pi))

if (!CreateProcess(NULL,szCommand,0,0,TRUE,CREATE_SUSPENDED,NULL,NULL,&si,&pi))
  {
  //fprintf(stderr,"Failed: CreateProcess(%s)\n",szExeName);
  //CloseHandle(h);
  //CloseHandle(herr);
  LogLastError();
  bStopGame = 1;
  }
else
  {
  DWORD d,st;
  /*
  FILETIME CreationTime;  // when the process was created
  FILETIME ExitTime;  // when the process exited
  FILETIME KernelTime;    // time the process has spent in kernel mode
  FILETIME UserTime;
  */

  st = GetTickCount();
  ResumeThread(pi.hThread);
  d=WaitForSingleObject(pi.hProcess,(int) (nTime[curPlayer]*1000));
  if (d == WAIT_TIMEOUT)
    {
    //fprintf(stderr,szTL,szExeName);
    MessageBox(0,szTL,0,MB_OK);
    TerminateProcess(pi.hProcess,0);
    bStopGame = 1;
    }
  else
    {
    //st = GetTickCount() - st;
    nTime[curPlayer] -= (GetTickCount() - st) * 0.001;
    /*
    GetProcessTimes(pi.hProcess,
                    &CreationTime,
                    &ExitTime,
                    &KernelTime,
                    &UserTime);
    nTime[curPlayer] -= ft2ld(&ExitTime)-ft2ld(&CreationTime);
    */
    #ifndef USE_PIPE
    if (hStdOut != INVALID_HANDLE_VALUE) SetStdHandle(STD_OUTPUT_HANDLE,hStdOut);
    CloseHandle(hMoveFile);
    #endif

    if (!doMoveFromPipe(pipe_in))
      {
      //fprintf(stderr,"illegal move (%s)\n",szExeName);
      MessageBox(0,"illegal move",0,MB_OK);
      bStopGame = 1;
      }
    //nTime[curPlayer] -= ft2ld(&KernelTime)+ft2ld(&UserTime);
    }
  CloseHandle(pi.hProcess);
  sprintf(szCommand,"%s:%s %d:%d (%.2Lf:%.2Lf) %.1lf-%.1lf",szFirstPlayer,szSecondPlayer,countScore(1),countScore(-1),nTime[1],nTime[2],fMatchPoints[0],fMatchPoints[1]);
  SetWindowText(hwndMain,szCommand);
  }
}
void drawBoard(HWND hwnd)
{
int i,j;
PAINTSTRUCT ps;
HGDIOBJ h1;

ps.hdc = GetDC(hwnd);
h1 = SelectObject(ps.hdc,GetStockObject(WHITE_BRUSH));
Rectangle(ps.hdc,cell/2,cell/2,(nColumnsp1 + 1) * cell - cell/2,(nRowsp1 + 1) * cell - cell/2);
for(j=1;j<=nRowsp1;j++)
  for(i=1;i<=nColumnsp1;i++)
    {
    char s[3];
    s[0] = 'A' + i - 1;
    s[1] = '1' + j - 1;
    s[2] = 0;
    //TextOut(ps.hdc,i*cell-cell/3,j*cell-cell/3,s,strlen(s));
    SetPixelV(ps.hdc,i*cell,j*cell,0);
    }
SelectObject(ps.hdc,h1);
ReleaseDC(hwnd,ps.hdc);
}


void initResource(void)
{
redPen = CreatePen(PS_SOLID,1,0x00ff0000);
bluePen = CreatePen(PS_SOLID,1,0x000000ff);
redBrush = CreateSolidBrush(0x00ff0000);
blueBrush=  CreateSolidBrush(0x000000ff);
hStdOut = GetStdHandle(STD_OUTPUT_HANDLE);

#ifdef USE_PIPE
CreatePipe(&pipe_in,&pipe_out,0,1024);
SetStdHandle(STD_OUTPUT_HANDLE,pipe_out);
#endif
}
void freeResource(void)
{
if (hStdOut != INVALID_HANDLE_VALUE) SetStdHandle(STD_OUTPUT_HANDLE,hStdOut);


#ifdef USE_PIPE
CloseHandle(pipe_in);
CloseHandle(pipe_out);
#endif

#ifndef USE_PIPE
DeleteFile(szMoveFile);
#endif

DeleteObject(redPen);
DeleteObject(bluePen);
DeleteObject(redBrush);
DeleteObject(blueBrush);
}

int mainGUI(int nGames)
{
char *w,*p;
FILE *f;
int s1,s2;
char szResult[16],tmp[MAX_PATH];
double d;
int i;
initResource();

GetModuleFileName(GetModuleHandle(NULL),szPath,sizeof(szPath));
w = szPath;
for(p = szPath;*p;p++)
  {
  if (*p == '/' || *p == '\\') w = p;
  }
w[1] = 0;
sprintf(szGameTxt,"%s%s",szPath,"game.txt");
/*
#ifdef D00
freopen("DEBUG","wt",stderr);
#endif
*/
f = fopen("game.ini","r");

//freopen("game.ini","r",stdin);
//freopen("game.err","w",stderr);
bStopGame = 0;
fscanf(f,"%d%d",&nr,&nc);
fclose(f);
fMatchPoints[0] = fMatchPoints[1] = 0.0;
for(i=0;i<nGames;i++)
  {
  initBoard(nr,nc,1);
  drawBoard(hwndMain);
  nTime[1] = nTime[2] = 60.0;
  curPlayer = 1;
  nMoves = 0;
  //Sleep(2000);
  //return 0;
  while(countFreeEdges() > 0)
    {
    if (curPlayer == 1)
      {
      GetMove(szFirstPlayer);
      //printf("   ");
      curPlayer = 2;
      }
    else
      {
      GetMove(szSecondPlayer);
      //printf(" %d:%d (%.2Lf:%.2Lf)\n",countScore(1),countScore(-1),nTime[1],nTime[2]);
      curPlayer = 1;
      }
    if (bStopGame) break;
    }


  printInputFile();
  f = fopen("db.pgn","a");
  fprintf(f,"[White \"%s\"]\n",szFirstPlayer);
  fprintf(f,"[Black \"%s\"]\n",szSecondPlayer);

  s1 = countScore(1),
  s2 = countScore(-1);
  if (s1 > s2)
    {
    strcpy(szResult,"1-0");
    fMatchPoints[0] += 1.0;
    }
  else if (s1 < s2)
    {
    strcpy(szResult,"0-1");
    fMatchPoints[1] += 1.0;
    }
  else
    {
    strcpy(szResult,"1/2-1/2");
    fMatchPoints[0] += 0.5;
    fMatchPoints[1] += 0.5;
    }
  fprintf(f,"[Result \"%s\"]\n",szResult);
  fprintf(f,"\n");
  printGame(f);
  fprintf(f,"%s\n",szResult);
  fprintf(f,"\n");
  fclose(f);

  strcpy(tmp,szFirstPlayer);
  strcpy(szFirstPlayer,szSecondPlayer);
  strcpy(szSecondPlayer,tmp);

  d = fMatchPoints[0];
  fMatchPoints[0] = fMatchPoints[1];
  fMatchPoints[1] = d;

  Sleep(2000);
  }


//scanf("%d%d%lf",&pNo,&pScore,&pTime);
//setPlayerInfo(pNo,pScore,pTime);
//scanf("%d%d%lf",&pNo,&pScore,&pTime);
//setPlayerInfo(pNo,pScore,pTime);
/*
while(scanf("%d%s%s",&pNo,s1,s2)==3)
  {
  DoMoveWithScore(pNo,s1,s2);
  }
#ifdef D00
printPossibleMoves(stderr);
#endif
t2 = (nTime[compPlayer] - 5.0) / upperBoundPlayerMoves();
t1 = t2 * 0.25;
m = findMove(t1,t2);
printMove(stdout,m);
*/
freeResource();

return 0;
}




char szCommandLine[1024];

/*<---------------------------------------------------------------------->*/
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, INT nCmdShow)
{
  char *p;
  MSG msg;
  HANDLE hAccelTable;
  int ng = 1;
  hInst = hInstance;
  if (!InitApplication())
    return 0;
  hAccelTable = LoadAccelerators(hInst,MAKEINTRESOURCE(IDACCEL));
  if ((hwndMain = CreatelinesboxWndClassWnd()) == (HWND)0)
    return 0;
  ShowWindow(hwndMain,SW_SHOW);
  strcpy(szCommandLine,lpCmdLine);
  p = strtok(szCommandLine," ");
  if (p == 0) return 0;
  strcpy(szFirstPlayer,p);
  p = strtok(NULL," ");
  if (p == 0) return 0;
  strcpy(szSecondPlayer,p);
  p = strtok(NULL," ");
  if (p != 0) ng = strtol(p,&p,10);
  mainGUI(ng);
  PostQuitMessage(0);
  while (GetMessage(&msg,NULL,0,0)) {
    if (!TranslateAccelerator(msg.hwnd,hAccelTable,&msg)) {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
    }
  }


  //return msg.wParam;
return 0;
}
