#define NDEBUG

#ifdef D00
#undef NDEBUG
#endif

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/timeb.h>
#include <assert.h>
#include "rules.c"

char szPath[MAX_PATH];

char szFirstPlayer[MAX_PATH];
char szSecondPlayer[MAX_PATH];
unsigned short moves[1024];
int nMoves;
int nr,nc,curPlayer;

const char szTL[] = "Time limit (%s)\n";
char szGameTxt[MAX_PATH];

int bStopGame;

void LogLastError(void)
{
    LPVOID lpMsgBuf;
    FormatMessage(
        FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
        NULL,
        GetLastError(),
        MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
        (LPTSTR) &lpMsgBuf,
        0,
        NULL
    );
    // Display the string.
    fprintf(stderr,"%s\n",lpMsgBuf);
    //EeyoreChessProgram_WriteToLog((char*)lpMsgBuf,LOG_ERR);
    // Free the buffer.
    LocalFree( lpMsgBuf );
}

HANDLE pipe_in,pipe_out;
unsigned char pipe_buf[1024];


int doMoveFromPipe(HANDLE *h)
{
char s1[256],s2[256];
MOVE m[MAX_MOVES];
int i,n;
unsigned short mm;
//FILE *f;
//f = fopen(szFile,"r");
//if (f == 0) return 0;
pipe_buf[0] = 0;
ReadFile(pipe_in,pipe_buf,1024,&n,NULL);
if (!n) return 0;

if (sscanf(pipe_buf,"%s%s",s1,s2) != 2) return 0;
//fclose(f);
enumerateAllMoves(m,&n);
mm = moveStr2short(s1,s2);
for(i=0;i<n;i++)
  {
  if (mm == m[i].m)
    {
    printf("%s %s",s1,s2);
    moves[nMoves++] = mm;
    DoMoveWithScore(curPlayer,s1,s2);
    return 1;
    }
  }
return 0;
}

void printInputFile(void)
{
int i;
FILE *f;
f = fopen(szGameTxt,"w");
fprintf(f,"%d %d %d\n",curPlayer,nr,nc);
for(i=1;i<=2;i++)
  {
  fprintf(f,"%d %d %.2Lf\n",i,countScore(player2int[i]),nTime[i]);
  }
for(i=0;i<nMoves;i++)
  {
  fprintf(f,"%d ",(i&1)+1);
  printMove(f,moves[i]);
  fprintf(f,"\n");
  }
fclose(f);
}

long double ft2ld(const FILETIME *ft)
{
long double x;
x = ft->dwHighDateTime;
x *= 4294967296.0;
x += ft->dwLowDateTime;
x *= 1e-7;
return x;
}

void GetMove(const char *szExeName)
{
STARTUPINFO si;
PROCESS_INFORMATION pi;
char szCommand[MAX_PATH];
//HANDLE h;
//HANDLE herr;
//FILE *f;
//DWORD st;
printInputFile();
//h = CreateFile("lastmove",GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
//herr = CreateFile("last.err",GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);


//f = fopen("lastmove","w");
memset(&si,0,sizeof(si));
si.cb = sizeof(si);
si.dwFlags = STARTF_USESTDHANDLES;
si.hStdOutput = pipe_out;
//si.hStdError = herr;

/*
f = fopen("__tmp.bat","w");
fprintf(f,"%s %s >lastmove\n",szExeName,szGameTxt);
fclose(f);
*/

sprintf(szCommand,"%s %s",szExeName,szGameTxt);
//if (!CreateProcess("__tmp.bat",NULL,0,0,TRUE,CREATE_NEW_CONSOLE,NULL,NULL,&si,&pi))
//if (!CreateProcess(szExeName,szGameTxt,0,0,TRUE,0,NULL,NULL,&si,&pi))

if (!CreateProcess(NULL,szCommand,0,0,TRUE,CREATE_SUSPENDED,NULL,NULL,&si,&pi))
  {
  fprintf(stderr,"Failed: CreateProcess(%s)\n",szExeName);
  //CloseHandle(h);
  //CloseHandle(herr);
  LogLastError();
  bStopGame = 1;
  }
else
  {
  DWORD d,st;
  /*
  FILETIME CreationTime;  // when the process was created
  FILETIME ExitTime;  // when the process exited
  FILETIME KernelTime;    // time the process has spent in kernel mode
  FILETIME UserTime;
  */

  st = GetTickCount();
  ResumeThread(pi.hThread);
  d=WaitForSingleObject(pi.hProcess,(int) (nTime[curPlayer]*1000));
  if (d == WAIT_TIMEOUT)
    {
    fprintf(stderr,szTL,szExeName);
    TerminateProcess(pi.hProcess,0);
    bStopGame = 1;
    }
  else
    {
    //st = GetTickCount() - st;
    nTime[curPlayer] -= (GetTickCount() - st) * 0.001;
    /*
    GetProcessTimes(pi.hProcess,
                    &CreationTime,
                    &ExitTime,
                    &KernelTime,
                    &UserTime);
    nTime[curPlayer] -= ft2ld(&ExitTime)-ft2ld(&CreationTime);
    */
    if (!doMoveFromPipe(pipe_in))
      {
      fprintf(stderr,"illegal move (%s)\n",szExeName);
      bStopGame = 1;
      }
    //nTime[curPlayer] -= ft2ld(&KernelTime)+ft2ld(&UserTime);
    }
  CloseHandle(pi.hProcess);
  }
}

int main(int argc,char **argv)
{
char *p,*w;
if (argc <= 2) {printf("Usage: game 001.exe 002.exe\n");return 0;}
strcpy(szFirstPlayer,argv[1]);
strcpy(szSecondPlayer,argv[2]);
GetModuleFileName(GetModuleHandle(NULL),szPath,sizeof(szPath));
w = szPath;
for(p = szPath;*p;p++)
  {
  if (*p == '/' || *p == '\\') w = p;
  }
w[1] = 0;
sprintf(szGameTxt,"%s%s",szPath,"game.txt");
/*
#ifdef D00
freopen("DEBUG","wt",stderr);
#endif
*/
freopen("game.ini","r",stdin);
freopen("game.err","w",stderr);
bStopGame = 0;

scanf("%d%d",&nr,&nc);
initBoard(nr,nc,1);
nTime[1] = nTime[2] = 60.0;
curPlayer = 1;
nMoves = 0;

CreatePipe(&pipe_in,&pipe_out,0,1024);

while(countFreeEdges() > 0)
  {
  if (curPlayer == 1)
    {
    GetMove(szFirstPlayer);
    printf("   ");
    curPlayer = 2;
    }
  else
    {
    GetMove(szSecondPlayer);
    printf(" %d:%d (%.2Lf:%.2Lf)\n",countScore(1),countScore(-1),nTime[1],nTime[2]);
    curPlayer = 1;
    }
  if (bStopGame) break;
  }
printInputFile();
//scanf("%d%d%lf",&pNo,&pScore,&pTime);
//setPlayerInfo(pNo,pScore,pTime);
//scanf("%d%d%lf",&pNo,&pScore,&pTime);
//setPlayerInfo(pNo,pScore,pTime);
/*
while(scanf("%d%s%s",&pNo,s1,s2)==3)
  {
  DoMoveWithScore(pNo,s1,s2);
  }
#ifdef D00
printPossibleMoves(stderr);
#endif
t2 = (nTime[compPlayer] - 5.0) / upperBoundPlayerMoves();
t1 = t2 * 0.25;
m = findMove(t1,t2);
printMove(stdout,m);
*/
CloseHandle(pipe_in);
CloseHandle(pipe_out);
return 0;
}
